/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.PList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PWrappedList
extends PList {
    public PWrappedList() {
        this.initList();
    }

    public PWrappedList(ListModel dataModel) {
        super(dataModel);
        this.initList();
    }

    public PWrappedList(Object[] listData) {
        super(listData);
        this.initList();
    }

    public PWrappedList(Vector listData) {
        super(listData);
        this.initList();
    }

    private void initList() {
        this.setCellRenderer(new CellRenderer());
        this.enableEvents(1L);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (e.getID() == 101) {
            this.setFixedCellWidth(this.getWidth());
        }
    }

    protected static class CellRenderer
    extends JTextArea
    implements ListCellRenderer {
        private static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
        private Dimension preferredSize = new Dimension();

        protected CellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list instanceof PList) {
                if (cellHasFocus) {
                    this.setBorder(((PList)list).getFocusedCellBorder());
                } else {
                    this.setBorder(((PList)list).getUnfocusedCellBorder());
                }
            } else if (cellHasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(EMPTY_BORDER);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setText(value.toString());
            this.setBounds(0, 0, list.getWidth(), 100);
            Dimension wrappedSize = super.getPreferredSize();
            this.preferredSize.width = wrappedSize.width;
            this.preferredSize.height = wrappedSize.height;
            return this;
        }
    }
}

